/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Collectable
**
** DESCRIPTION:	Manages collectables - anything which can be picked up
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef COLLECTABLE_H
#define COLLECTABLE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
class CVillager;
class ICollectable;

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int Collectable_c_iMaxObservers = 3;

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum ECarrying
{
	eCarrying_Nothing = -1,

	eCarrying_Berries,
	eCarrying_Rocks,
	eCarrying_Feathers,
	eCarrying_Baby,
	eCarrying_Wood,
	eCarrying_Laundry,
	eCarrying_Crops,
	eCarrying_Flowers,
	eCarrying_Fish,
	eCarrying_Crab,
	eCarrying_Water,
	eCarrying_Body,
	eCarrying_MagicFish,
	eCarrying_Shroom,
	eCarrying_RareShroom,
	eCarrying_Kindling,
	eCarrying_Coconut,
	eCarrying_EmptyBowl,
	eCarrying_Tool,
	eCarrying_Pot,
	eCarrying_FullPot,
	eCarrying_Herbs,
	eCarrying_Speartips,
	eCarrying_Bounty,
	eCarrying_LabEquip1,
	eCarrying_LabEquip2,

	eCarrying_AlchemyLabPiece1,
	eCarrying_AlchemyLabPiece2,
	eCarrying_AlchemyLabPiece3,
	eCarrying_AlchemyLabPiece4,
	eCarrying_AlchemyLabPiece5,
	eCarrying_Herb1,
	eCarrying_Herb2,
	eCarrying_Herb3,
	eCarrying_Herb4,
	eCarrying_Herb5,
	eCarrying_Herb6,
	eCarrying_Herb7,
	eCarrying_Banana,
	eCarrying_Mango,
	eCarrying_Papaya,
	eCarrying_Honey,
	eCarrying_SmokingStick,
    eCarrying_BowlOfJunk,
	eCarrying_Key1,
	eCarrying_Key2,
	eCarrying_Key3,
	eCarrying_SharkCharmerVial,
	eCarrying_Leaves,
	eCarrying_GiantPearl,
	eCarrying_BurnedTorch,
	eCarrying_BrokenPearl,

	// Items below are not part of the carrying image strip!
	eCarrying_BeginCollectables,

	eCarrying_Shell1 = eCarrying_BeginCollectables,
	eCarrying_Shell2,
	eCarrying_Shell3,
	eCarrying_Shell4,
	eCarrying_Shell5,
	eCarrying_Shell6,
	eCarrying_Shell7,
	eCarrying_Shell8,
	eCarrying_Shell9,
	eCarrying_Shell10,
	eCarrying_Shell11,
	eCarrying_Shell12,
	eCarrying_Coral1,
	eCarrying_Coral2,
	eCarrying_Coral3,
	eCarrying_Coral4,
	eCarrying_Coral5,
	eCarrying_Coral6,
	eCarrying_Coral7,
	eCarrying_Coral8,
	eCarrying_Coral9,
	eCarrying_Coral10,
	eCarrying_Coral11,
	eCarrying_Coral12,
	eCarrying_Tablet1,
	eCarrying_Tablet2,
	eCarrying_Tablet3,
	eCarrying_Tablet4,
	eCarrying_Tablet5,
	eCarrying_Tablet6,
	eCarrying_Tablet7,
	eCarrying_Tablet8,
	eCarrying_Tablet9,
	eCarrying_Tablet10,
	eCarrying_Tablet11,
	eCarrying_Tablet12,
	eCarrying_Feather1,
	eCarrying_Feather2,
	eCarrying_Feather3,
	eCarrying_Feather4,
	eCarrying_Feather5,
	eCarrying_Feather6,
	eCarrying_Feather7,
	eCarrying_Feather8,
	eCarrying_Feather9,
	eCarrying_Feather10,
	eCarrying_Feather11,
	eCarrying_Feather12,
	eCarrying_Shroom1,
	eCarrying_Shroom2,
	eCarrying_Shroom3,

	eCarrying_NumberOf
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CCollectable
{
private:

	//class structures
	struct SCollectable
	{
		ICollectable *	m_pObserver[Collectable_c_iMaxObservers];
		int				m_iNumObservers;
	};

	//class data
//	static ICollectable *	sm_pCollectable[eCarrying_NumberOf];

	SCollectable		m_sCollectable[eCarrying_NumberOf];

	//class methods
	//setup
	public:		CCollectable(void);
	public:		void RegisterObserver(const ECarrying eCarrying, ICollectable *pObserver);

	// process
	public:		const bool ProcessNearbyCollectables(CVillager &Villager) const;
	public:		const bool Carry(CVillager &Villager, const ECarrying eCarrying) const;
	public:		void Drop(CVillager &Villager, const ECarrying eCarrying) const;

	// access
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CCollectable		Collectable;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/